#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private ChartSpots.VWAPAnchored[] cacheVWAPAnchored;

		
		public ChartSpots.VWAPAnchored VWAPAnchored(DateTime anchorDateTime)
		{
			return VWAPAnchored(Input, anchorDateTime);
		}


		
		public ChartSpots.VWAPAnchored VWAPAnchored(ISeries<double> input, DateTime anchorDateTime)
		{
			if (cacheVWAPAnchored != null)
				for (int idx = 0; idx < cacheVWAPAnchored.Length; idx++)
					if (cacheVWAPAnchored[idx].AnchorDateTime == anchorDateTime && cacheVWAPAnchored[idx].EqualsInput(input))
						return cacheVWAPAnchored[idx];
			return CacheIndicator<ChartSpots.VWAPAnchored>(new ChartSpots.VWAPAnchored(){ AnchorDateTime = anchorDateTime }, input, ref cacheVWAPAnchored);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.ChartSpots.VWAPAnchored VWAPAnchored(DateTime anchorDateTime)
		{
			return indicator.VWAPAnchored(Input, anchorDateTime);
		}


		
		public Indicators.ChartSpots.VWAPAnchored VWAPAnchored(ISeries<double> input , DateTime anchorDateTime)
		{
			return indicator.VWAPAnchored(input, anchorDateTime);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.ChartSpots.VWAPAnchored VWAPAnchored(DateTime anchorDateTime)
		{
			return indicator.VWAPAnchored(Input, anchorDateTime);
		}


		
		public Indicators.ChartSpots.VWAPAnchored VWAPAnchored(ISeries<double> input , DateTime anchorDateTime)
		{
			return indicator.VWAPAnchored(input, anchorDateTime);
		}

	}
}

#endregion
